﻿Public Class Form1

    'Składowa z poziomu formularza.
    Private objCustomers As New CustomerCollection

    Public Sub CreateCustomer(ByVal firstName As String, _
    ByVal lastName As String, ByVal email As String)

        ' Deklaracja obiektu Customer.
        Dim objNewCustomer As Customer

        ' Tworzenie nowej zmiennej Customer.
        objNewCustomer.FirstName = firstName
        objNewCustomer.LastName = lastName
        objNewCustomer.Email = email

        ' Dodawanie nowej zmiennej do listy.
        objCustomers.Add(objNewCustomer)

        ' Dodawanie nowej zmiennej do kontrolki ListBox.
        lstCustomers.Items.Add(objNewCustomer)
    End Sub

    Public Sub DisplayCustomer(ByVal customer As Customer)
        ' Wyświetlanie na formularzu szczegółowych informacji o kliencie.
        txtName.Text = customer.Name

        txtFirstName.Text = customer.FirstName
        txtLastName.Text = customer.LastName
        txtEmail.Text = customer.Email
    End Sub

    Private Sub btnListCustomer_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnListCustomer.Click

        ' Czyszczenie list.
        objCustomers.Clear()
        lstCustomers.Items.Clear()

        ' Tworzenie kilku zmiennych typu Customer.
        CreateCustomer("Dariusz", "Hańko", "dhanko@jakasfirma.pl")
        CreateCustomer("Franciszek", "Michalski", "fmich@jakasfirma.pl")
        CreateCustomer("Bogdan", "Szkot", "bszkot@jakasfirma.pl")

    End Sub

    Public ReadOnly Property SelectedCustomer() As Customer
        Get
            If lstCustomers.SelectedIndex <> -1 Then
                ' Zwraca wybranego klienta.
                Return objCustomers(lstCustomers.SelectedIndex)
            End If
        End Get
    End Property

    Private Sub btnDeleteCustomer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeleteCustomer.Click

        ' Jeśli na liście nie jest wybrana żadna pozycja…
        If lstCustomers.SelectedIndex = -1 Then

            ' Wyświetlanie komunikatu.
            MessageBox.Show("Musisz wybrać klienta.", _
               "Struktury")

            ' Wyjście z metody.
            Exit Sub
        End If

        ' Prośba o zatwierdzenie usunięcia wybranej pozycji.
        If MessageBox.Show("Czy na pewno chcesz usunąć " & _
           SelectedCustomer.Name & "?", "Struktury", _
           MessageBoxButtons.YesNo, MessageBoxIcon.Question) = _
           DialogResult.Yes Then

            ' Pobieranie usuwanego klienta.
            Dim objCustomerToDelete As Customer = SelectedCustomer

            ' Usuwanie klienta z tablicy ArrayList.
            objCustomers.Remove(objCustomerToDelete)

            ' Usuwanie klienta z kontrolki ListBox.
            lstCustomers.Items.Remove(objCustomerToDelete)
        End If

    End Sub

    Private Sub lstCustomers_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstCustomers.SelectedIndexChanged

        ' Wyświetlanie szczegółów dotyczących klienta.
        DisplayCustomer(SelectedCustomer)

    End Sub

    Private Sub btnLookup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLookup.Click

        ' Deklaracja obiektu typu Customer i przypisanie do niego 
        ' danych klienta o określonym adresie e-mail.
        Dim objFoundCustomer As Customer = objCustomers(txtEmail.Text)

        If Not IsNothing(objFoundCustomer.Email) Then
            ' Wyświetlanie imienia i nazwiska klienta.
            MessageBox.Show("Imię i nazwisko klienta: " & _
                 objFoundCustomer.Name, "Struktury")
        Else
            ' Wyświetlanie komunikatu o błędzie.
            MessageBox.Show("Nie znaleziono klienta o adresie " & _
               txtEmail.Text & ".", "Struktury")
        End If

    End Sub
End Class
